create or replace package tbicds.PCK_USER_ADMIN
AUTHID CURRENT_USER
is
/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
  --return recordsets
  type RetRefCursor is ref cursor;

  procedure GetUserLookupRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_vDMISID          in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2,
                            rs                  out RetRefCursor);

  procedure GetUserLookupBySearchRS(pi_vSessionID       in varchar2,
                                    pi_vSessionClientIP in varchar2,
                                    pi_nUserID          in number,
                                    pi_vSearchValue     in varchar2,
                                    po_nStatusCode      out number,
                                    po_vStatusComment   out varchar2,
                                    rs                  out RetRefCursor);

  procedure GetSuatUserRS(pi_vSessionID       in varchar2,
                          pi_vSessionClientIP in varchar2,
                          pi_nUserID          in number,
                          pi_vProviderID      in varchar2,
                          po_nStatusCode      out number,
                          po_vStatusComment   out varchar2,
                          rs                  out RetRefCursor);

  procedure GetSuatUserNameRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_nFXUserID        in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure GetFacilityInfoRS(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2,
                              rs                  out RetRefCursor);

  procedure InsertFacilityInfo(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vSiteID          in varchar2,
                               pi_vSiteName        in varchar2,
                               pi_vSiteAddress1    in varchar2,
                               pi_vSiteCity        in varchar2,
                               pi_vSiteState       in varchar2,
                               pi_vSitePostalCode  in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2);

  procedure UpdateFacilityInfo(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vSiteID          in varchar2,
                               pi_vSiteName        in varchar2,
                               pi_vSiteAddress1    in varchar2,
                               pi_vSiteCity        in varchar2,
                               pi_vSiteState       in varchar2,
                               pi_vSitePostalCode  in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2);

  procedure UpdateGraphPref(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_nGraphOpt        in varchar2,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2);

  procedure GetGraphPref(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2,
                         rs                  out RetRefCursor);

end;
/

